---
name: technical-icp-architect
description: Expert guide for defining Ideal Customer Profiles (ICP) for technical products. Use this skill when the user needs to define who they are selling to based on technology stacks, engineering pain points, and team constraints rather than generic personas.
---

# Technical ICP Architect

This skill guides the definition of an Ideal Customer Profile (ICP) specifically for technical products (DevTools, B2B SaaS, Infrastructure).

## Usage Instructions

When the user asks to "define our customer" or "who is this for?", conduct a structured interview to fill out the four dimensions below. Do not accept generic answers (e.g., "Developer"). Push for specific stack constraints and pain points.

## 01. The Identity (The "Who")
*Constraint-based definition.*

| Variable | Good Example | Bad Example |
| :--- | :--- | :--- |
| **Role** | "Senior DevOps Engineer managing K8s clusters" | "Developer" |
| **Stage** | "Series B, post-PMF, scaling to 50 engineers" | "Startup" |
| **Stack** | "Python shops using Celery + Redis for async tasks" | "Tech companies" |

## 02. The Technical Pain (The "Why Now")
*The specific engineering bottleneck that forces a purchase.*

*   **Primary Symptom:** (e.g., "CI/CD builds take >45 mins, causing context switching")
*   **Current Hacky Workaround:** (e.g., "They wrote a custom bash script that flakes 50% of the time")
*   **Trigger Event:** (e.g., "Migration from Heroku to AWS")

## 03. The Business Impact (The "So What")
*Translation of code problems into executive problems.*

*   **Metric:** (e.g., "Developer idle time costs $20k/mo")
*   **Executive Pressure:** (e.g., "CTO is under pressure to ship the mobile app by Q3")

## 04. The Anti-Persona (The "Who Not")
*Explicit disqualification criteria.*

*   **Technology:** (e.g., "Windows-server environments")
*   **Team:** (e.g., "Outsourced dev teams")
*   **Mindset:** (e.g., "Prefers 'All-in-one' GUI tools over API primitives")

---
*Version: 2.0.0 | Pathak Ventures Skill*
