---
name: production-launch-checklist
description: Critical pre-flight verification for technical product launches. Use this skill to validate infrastructure, SEO metatags, and tracking instrumentation before deploying to production or posting to aggregators like Hacker News.
---

# Production Launch Checklist

This skill serves as the "Go/No-Go" authority for high-fidelity product launches. It treats marketing launches with the same severity as production code deployments.

## Check Procedure
Run through these checks sequentially. Mark items as `[PASS]`, `[FAIL]`, or `[WARN]`.

## 01. Infrastructure Hardening (The "Hug of Death" Defense)
*Can we survive the front page of Hacker News?*

- [ ] **Load Testing:** `k6` or `locust` run against endpoints. Verified 10x normal concurrency.
- [ ] **Edge Caching:** Static assets are served via CDN (Cloudflare/Vercel Edge).
- [ ] **Rate Limits:** API endpoints have strict rate limiting per IP to prevent abuse/scraping.
- [ ] **Error Monitoring:** Sentry/Datadog alerts configured to filter noise vs. critical 500s.

## 02. The Head Tags (Social Parsers)
*How we appear in the feed.*

- [ ] **Title Tag:** `<60 chars`. High information density. No marketing fluff.
- [ ] **Meta Description:** `<160 chars`. Value prop + active verb.
- [ ] **OG:Image:** Custom 1200x630px visual. **NOT** the logo. **NOT** a stock photo.
- [ ] **Twitter Card:** `summary_large_image`. Verified via Twitter Validator.
- [ ] **Canonical Self-Reference:** `<link rel="canonical">` points to self to prevent mirror flagging.

## 03. Telemetry & Attribution
*If we don't track it, it didn't happen.*

- [ ] **UTM Strategy:** All external links (Twitter, HN, Reddit, Email) have unique `utm_source` / `utm_medium`.
- [ ] **Event Verification:** "Sign Up" button fires the *correct* event in Mixpanel/Posthog.
- [ ] **Pixel Helper:** LinkedIn/Meta pixels verified active if running paid retargeting.

## 04. QA & Content (The "Nitpick" Pass)
- [ ] **Fold Check:** On 13" MacBook, H1 + CTA are visible without scroll.
- [ ] **Mobile Responsive:** No horizontal scroll on iPhone 12 width.
- [ ] **Broken Link Crawler:** Ran `wget` spider or link-checker tool.
- [ ] **Favicon:** Verified visibility in Dark Mode and Light Mode tabs.

## 05. Distribution Channel Prep
- [ ] **Hacker News:** Title formulated to be *intellectually interesting* (e.g., "Show HN: We built X to solve Y", not "The best way to do X").
- [ ] **Product Hunt:** Maker comment drafted (Mission + The "Why" + Ask for feedback).
- [ ] **Reddit:** identified 3 *relevant* subreddits. Formatted self-text post (not link-only).

---
*Version: 2.0.0 | Pathak Ventures Skill*
