---
name: growth-science-logger
description: Scientific framework for tracking revenue experiments. Use this skill to help users design, log, and analyze growth experiments with engineering rigor (variables, hypotheses, control groups).
---

# Growth Science Logger

This skill provides a strict framework for running marketing and growth experiments as if they were engineering deployments.

## Core Principle
**"Marketing is physics, not magic."** Every action is an experiment with a hypothesis, variables, and measurable outcomes.

## Experiment Record Protocol
For every proposed growth initiative, force the user to define the following parameters using the `Experiment Commit Log` format.

### The Commit Log Template

```markdown
## Experiment #[ID]: [Title]
**Status:** `DRAFT` | `RUNNING` | `CONCLUDED` | `SHIPPED`

### 1. Hypothesis (The 'If/Then')
"If we [Independent Variable], then [Dependent Variable] will change by [Magnitude] because [Mechanism]."

> Example: "If we replace the 'Book Demo' button with 'npm install pkg', conversion to activation will increase by 15% because leads can self-service test the library."

### 2. Variables
*   **Independent (Changed):** (e.g., The Hero CTA Text)
*   **Dependent (Measured):** (e.g., Click-through rate to /docs)
*   **Control/Variance:** (e.g., 50% traffic split via Vercel Edge Config)

### 3. Implementation Specs
*   **Code:** [Link to PR or diff]
*   **Events:** (e.g., Mixpanel event `hero_cta_clicked` with prop `text_variant`)
*   **Sample Size Required:** (e.g., n=1000 unique visitors for P<0.05)

### 4. Results
*   **Control Conversion:** `0.00%`
*   **Variant Conversion:** `0.00%`
*   **Confidence:** (Significance level)

### 5. Decision
*   [ ] **Promote to Prod:** (Winner)
*   [ ] **Revert:** (Loser)
*   [ ] **Pivot:** (Inconclusive)
```

## Usage Instructions
1.  **Challenge Assumptions:** If a user suggests an idea ("Let's change the color"), ask for the *Hypothesis* first.
2.  **Enforce Measurement:** Do not allow an experiment to "Launch" without defined tracking events.
3.  **Treat as Code:** Encourage version controlling these prose logs alongside the codebase.

---
*Version: 2.0.0 | Pathak Ventures Skill*
